# GoMage Configurator module.

### Module description

The base module has a list of useful functions, that can simplify
development process.

## Installation

1. You should add the GoMage Satis repository to your composer.json file.

```
"repositories": {
        "satis.gomage": {
            "type": "composer",
            "url": "https://satis.gomage.dev"
        }
    }
```

2. Add your GoMage Satis credentials to the auth.json file or entry it during the module installation process.

3. You should require the configurator module.

```
composer require gomage/module-base
```

### Entity Interface

GoMage_Base::Api/Data/EntityInterface is a base interface, that
should be extended by each of the interfaces, that will be implemented
in the data model.

### Working with repositories

If you want to create your repository you should follow the next steps:

1. Create the Repository interface in the Vendor_Module/Api directory. Your interface should extend the GoMage_Base::Api/RepositoryInterface. You can change params of return type in the method description comment, but not in the method definition.
2. Make sure, that your data interface extends the GoMage_Base::Api/Data/EntityInterface.
3. Create the Vendor_Module::Model\Repository\YourRepository class, that will extend the GoMage_Base::Model/Repository/BaseRepository and will implement GoMage_Base::Api/RepositoryInterface.
4. Add DI configuration to the repository. You should add the configuration in the next format:

```
<type name="Vendor\Module\Model\Repository\TitleRepository">
    <arguments>
        <argument name="entityCollectionFactory" xsi:type="string">GoMage\MageWorxOption\Model\ResourceModel\Title\CollectionFactory</argument>
        <argument name="entityFactory" xsi:type="string">GoMage\MageWorxOption\Api\Data\TitleInterfaceFactory</argument>
        <argument name="entityResource" xsi:type="object">GoMage\MageWorxOption\Model\ResourceModel\Title</argument>
    </arguments>
</type>
```
