<?php
/**
 * Base Repository Helper
 *
 * @category GoMage
 * @package GoMage/Base
 * @author Stanislav Miroshnyk <smiroshnyk@gomage.com>
 * @copyright 2022 GoMage
 */
declare(strict_types=1);

namespace GoMage\Base\Helper;

use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\Api\SearchCriteria;

/**
 * Class BaseRepository
 */
class BaseRepository extends AbstractHelper
{
    /**
     * BaseRepository constructor.
     *
     * @param Context $context
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     */
    public function __construct(
        Context $context,
        protected SearchCriteriaBuilder $searchCriteriaBuilder
    ) {
        parent::__construct($context);
    }

    /**
     * Get Search Criteria
     *
     * @param string $filed
     * @param string $value
     * @param string $condition
     *
     * @return SearchCriteria
     */
    public function getSearchCriteria(string $filed, string $value, string $condition = 'eq'): SearchCriteria
    {
        return $this->searchCriteriaBuilder->addFilter(
            $filed,
            $value,
            $condition
        )->create();
    }
}
