<?php
/**
 * Entity Interface
 *
 * @category GoMage
 * @package GoMage/Base
 * @author Stanislav Miroshnyk <smiroshnyk@gomage.com>
 * @copyright 2021 GoMage
 */
declare(strict_types=1);

namespace GoMage\Base\Api\Data;

/**
 * Class EntityInterface
 *
 * @package GoMage\Base\Api\Data
 */
interface EntityInterface
{
    /**
     * Get Id
     *
     * @return int
     */
    public function getId();

    /**
     * Get Entity Id
     *
     * @return int
     */
    public function getEntityId();

    /**
     * Set Entity Id
     *
     * @param int $entityId
     *
     * @return EntityInterface
     */
    public function setEntityId($entityId);
}
