<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Model;

use GoAi\Translator\Api\Data\TranslationStoreInterface;
use GoAi\Translator\Model\ResourceModel\TranslationStore as TranslationStoreResourceModel;
use Magento\Framework\Model\AbstractModel;

/**
 * Description
 */
class TranslationStore extends AbstractModel implements TranslationStoreInterface
{
    /**
     * Prefix of model events names
     *
     * @var string
     */
    protected $_eventPrefix = 'goai_translation_store';

    /**
     * @inheritdoc
     */
    protected function _construct()
    {
        $this->_init(TranslationStoreResourceModel::class);
    }

    /**
     * @inheritDoc
     */
    public function getTranslationId(): int
    {
        return (int)$this->getData(TranslationStoreInterface::TRANSLATION_ID);
    }

    /**
     * @inheritDoc
     */
    public function setTranslationId(int $translationId): TranslationStoreInterface
    {
        return $this->setData(TranslationStoreInterface::TRANSLATION_ID, $translationId);
    }

    /**
     * @inheritDoc
     */
    public function getStoreId(): int
    {
        return (int)$this->getData(TranslationStoreInterface::STORE_ID);
    }

    /**
     * @inheritDoc
     */
    public function setStoreId(int $storeId): TranslationStoreInterface
    {
        return $this->setData(TranslationStoreInterface::STORE_ID, $storeId);
    }
}
