<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Block\Adminhtml\Store;

use GoAi\Translator\Api\TranslationQueueManagerInterface;
use GoAi\Translator\Helper\Config as ConfigHelper;
use Magento\Backend\Block\System\Store\Edit as EditForm;
use Magento\Backend\Block\Widget\Context;
use Magento\Framework\Registry;
use Magento\Framework\Serialize\SerializerInterface;
use Magento\Store\Model\Store;

/**
 * Class Edit
 */
class Edit extends EditForm
{
    /**
     * Edit constructor.
     *
     * @param Context $context
     * @param Registry $registry
     * @param ConfigHelper $configHelper
     * @param TranslationQueueManagerInterface $translationQueueManager
     * @param array $data
     * @param SerializerInterface|null $serializer
     */
    public function __construct(
        Context $context,
        Registry $registry,
        protected ConfigHelper $configHelper,
        protected TranslationQueueManagerInterface $translationQueueManager,
        array $data = [],
        SerializerInterface $serializer = null
    ) {
        parent::__construct($context, $registry, $data, $serializer);
    }

    /**
     * @inheritDoc
     */
    protected function _construct()
    {
        parent::_construct();

        if ($this->isAddRunButton()) {
            $this->addButton(
                'translation',
                [
                    'label' => __('Run Translation'),
                    'class' => 'translation',
                    'onclick' => "document.getElementById('translation-form').submit();",
                ]
            );
        }
    }

    /**
     * Check if the "Run Translation" button should be added
     * @return bool
     */
    protected function isAddRunButton(): bool
    {
        $storeId = $this->getStoreId();

        return $this->_coreRegistry->registry('store_type') === 'store' &&
            $storeId !== Store::DEFAULT_STORE_ID &&
            $storeId !== $this->configHelper->getDefaultStoreId() &&
            !$this->isOnboardingStarted();
    }

    /**
     * @return int
     */
    protected function getStoreId(): int
    {
        return (int)$this->_coreRegistry->registry('store_data')->getId();
    }

    /**
     * @return bool
     */
    protected function isOnboardingStarted(): bool
    {
        return $this->translationQueueManager->getEntitiesCountInQueue($this->getStoreId()) > 0;
    }
}
