<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Block\Adminhtml\Product\Attribute;

use GoAi\Translator\Helper\Config as ConfigHelper;
use Magento\Backend\Block\Widget\Context;
use Magento\Catalog\Block\Adminhtml\Product\Attribute\Edit as BaseEdit;
use Magento\Framework\Registry;

/**
 * Product attribute edit page
 */
class Edit extends BaseEdit
{
    /**
     * Edit constructor.
     *
     * @param Context $context
     * @param Registry $registry
     * @param array $data
     */
    public function __construct(
        Context $context,
        Registry $registry,
        protected ConfigHelper $configHelper,
        array $data = []
    ) {
        parent::__construct($context, $registry, $data);
    }

    protected function _construct()
    {
        parent::_construct();

        if (!$this->configHelper->isTranslatorEnabled()) {
            return;
        }

        $attributeId = $this->getRequest()->getParam('attribute_id');

        if ($attributeId === null) {
            return;
        }

        $this->addButton(
            'goAiTranslate',
            [
                'label' => __('Translate with AI'),
                'on_click' => 'confirmSetLocation(\'' . __(
                        'Are you sure you want to translate this product?'
                    ) . '\', \'' . $this->getUrl('goai_translator/translation/addToQueue') . '\', {data: {selected: ['
                    . $attributeId . '], entity_type: "product_eav_attribute"}})',
                'class' => '',
                'sort_order' => 15
            ]
        );
    }
}
