<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Block\Adminhtml\Config\Field;

use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;

/**
 * Class ExcludedTerms
 */
class ExcludedTerms extends AbstractFieldArray
{
    /**
     * @inheritdoc
     */
    protected function _prepareToRender(): void
    {
        $this->addColumn(
            'excluded_term',
            [
                'label' => __('Term'),
                'class' => 'required-entry'
            ]
        );

        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add');
    }
}
