<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Api;

use GoAi\Translator\Api\Data\TranslationInterface;
use GoMage\Base\Api\Data\EntityInterface;
use GoMage\Base\Api\RepositoryInterface;
use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Api\SearchResultsInterface;
use Magento\Framework\Exception\LocalizedException;

/**
 * Translation Repository Interface
 */
interface TranslationRepositoryInterface extends RepositoryInterface
{
    /**
     * Save Translation
     *
     * @param EntityInterface&TranslationInterface $translation
     * @return EntityInterface&TranslationInterface
     */
    public function save(EntityInterface $translation): EntityInterface;

    /**
     * Get Translation by ID
     *
     * @param int $translationId
     * @return EntityInterface&TranslationInterface
     */
    public function get(int $translationId): EntityInterface;

    /**
     * Delete Translation
     *
     * @param EntityInterface&TranslationInterface $translation
     * @return bool
     */
    public function delete(EntityInterface $translation): bool;
}
