<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Api;

/**
 * Description
 */
interface EntityTranslatorInterface
{
    /**
     * Get Entity Type
     * @return int[]
     */
    public function getEntityIdsForTranslation(int|null $storeId = null): array;

    /**
     * Get Prepared Entity Data For Send To Translation Service
     *
     * @param int $entityId
     * @return array
     */
    public function getPreparedEntityData(int $entityId): array;

    /**
     * Get Prepared Entity Data By Store ID
     *
     * @param int $entityId
     * @param int $storeId
     * @param bool $isSkipAttributes
     * @return array
     */
    public function getPreparedEntityDataByStoreId(int $entityId, int $storeId, bool $isSkipAttributes = false): array;

    /**
     * Save Translated Data
     *
     * @param array $entityData
     * @param array $storeIds
     * @return void
     */
    public function saveTranslatedData(array $entityData, array $storeIds): void;

    /**
     * Get Default Store ID
     * @return int
     */
    public function getDefaultStoreId(): int;
}
