<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Api\Data;

/**
 * Translation Store Interface
 */
interface TranslationStoreInterface
{
    /**
     * Table Name
     */
    public const TABLE_NAME = 'goai_translation_store';

    /**
     * Field List
     */
    public const TRANSLATION_ID = 'translation_id';
    public const STORE_ID = 'store_id';

    /**
     * Get Translation ID
     * @return int
     */
    public function getTranslationId(): int;

    /**
     * Set Translation ID
     * @param int $translationId
     * @return TranslationStoreInterface
     */
    public function setTranslationId(int $translationId): TranslationStoreInterface;

    /**
     * Get Store ID
     * @return int
     */
    public function getStoreId(): int;

    /**
     * Set Store ID
     * @param int $storeId
     * @return TranslationStoreInterface
     */
    public function setStoreId(int $storeId): TranslationStoreInterface;
}
