<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Api\Data;

use GoMage\Base\Api\Data\EntityInterface;

/**
 * Translation Interface
 */
interface TranslationInterface extends EntityInterface
{
    /**
     * Table Name
     */
    public const TABLE_NAME = 'goai_translation_queue';

    /**
     * Field List
     */
    public const TRANSLATION_ID = 'translation_id';
    public const ENTITY_TYPE = 'entity_type';
    public const ORIGINAL_ENTITY_ID = 'original_entity_id';
    public const TRANSLATION_TYPE = 'translation_type';
    public const STATUS = 'status';
    public const CREATED_AT = 'created_at';
    public const UPDATED_AT = 'udpated_at';
    public const COMMENT = 'comment';

    public const STORE_IDS = 'store_ids';

    /**
     * Get Entity Type
     * @return string
     */
    public function getEntityType(): string;

    /**
     * Set Entity Type
     * @param string $entityType
     * @return TranslationInterface
     */
    public function setEntityType(string $entityType): TranslationInterface;

    /**
     * Get Entity ID
     * @return int
     */
    public function getOriginalEntityId(): int;

    /**
     * Set Entity ID
     * @param int $entityId
     * @return TranslationInterface
     */
    public function setOriginalEntityId(int $entityId): TranslationInterface;

    /**
     * Get Translation Type
     * @return int
     */
    public function getTranslationType(): int;

    /**
     * Set Translation Type
     * @param int $translationType
     * @return TranslationInterface
     */
    public function setTranslationType(int $translationType): TranslationInterface;

    /**
     * Get Status
     * @return int
     */
    public function getStatus(): int;

    /**
     * Set Status
     * @param int $status
     * @return TranslationInterface
     */
    public function setStatus(int $status): TranslationInterface;

    /**
     * Get Created At
     *
     * @return string
     */
    public function getCreatedAt(): string;

    /**
     * Set Created At
     * @param string $createdAt
     * @return TranslationInterface
     */
    public function setCreatedAt(string $createdAt): TranslationInterface;

    /**
     * Get Updated At
     *
     * @return string
     */
    public function getUpdatedAt(): string;

    /**
     * Set Updated At
     * @param string $updatedAt
     * @return TranslationInterface
     */
    public function setUpdatedAt(string $updatedAt): TranslationInterface;

    /**
     * Get Comment
     * @return string
     */
    public function getComment(): string;

    /**
     * Set Comment
     * @param string $comment
     * @return TranslationInterface
     */
    public function setComment(string $comment): TranslationInterface;

    /**
     * Get Store IDs
     * @return array
     */
    public function getStoreIds(): array;

    /**
     * Set Store IDs
     * @param array $storeIds
     * @return TranslationInterface
     */
    public function setStoreIds(array $storeIds): TranslationInterface;
}
