<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Block\Adminhtml\CmsPage\Edit\Button;

use GoAi\Translator\Helper\Config as ConfigHelper;
use Magento\Backend\Block\Widget\Context;
use Magento\Cms\Api\Data\PageInterface;
use Magento\Cms\Api\PageRepositoryInterface;
use Magento\Cms\Block\Adminhtml\Page\Edit\GenericButton;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;
use Magento\Store\Model\Store;

/**
 * Cms Page Translate Button Block
 */
class Translate extends GenericButton implements ButtonProviderInterface
{
    public function __construct(
        Context $context,
        PageRepositoryInterface $pageRepository,
        protected ConfigHelper $configHelper
    ) {
        parent::__construct($context, $pageRepository);
    }

    public function getButtonData(): array
    {
        if (!$this->configHelper->isTranslatorEnabled()) {
            return [];
        }

        $pageId = $this->getPageId();

        if ($pageId === null) {
            return [];
        }

        try {
            $defaultStoreId = $this->configHelper->getDefaultStoreId();
            $page = $this->pageRepository->getById($pageId);

            if ($this->isDisabled($defaultStoreId, $page)) {
                return [];
            }
        } catch (NoSuchEntityException) {
            return [];
        }

        return [
            'label' => __('Translate with AI'),
            'on_click' => 'confirmSetLocation(\'' . __(
                    'Are you sure you want to translate this product?'
                ) . '\', \'' . $this->getUrl('goai_translator/translation/addToQueue') . '\', {data: {selected: ['
                . $pageId . '], entity_type: "cms_page"}})',
            'class' => 'action-secondary',
            'sort_order' => 15
        ];
    }

    /**
     * @param int $defaultStoreId
     * @param PageInterface $page
     * @return bool
     */
    public function isDisabled(int $defaultStoreId, PageInterface $page): bool
    {
        return !in_array($defaultStoreId, $page->getStores()) &&
            !in_array(Store::DEFAULT_STORE_ID, $page->getStores());
    }
}
