<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Model\ResourceModel\TranslationStore;

use GoAi\Translator\Api\Data\TranslationStoreInterface;
use GoAi\Translator\Model\TranslationStore as TranslationStoreModel;
use GoAi\Translator\Model\ResourceModel\TranslationStore as TranslationStoreResource;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;

/**
 * Class Collection
 */
class Collection extends AbstractCollection
{
    /**
     * @var string
     */
    protected $_idFieldName = TranslationStoreInterface::TRANSLATION_ID;

    /**
     * @inheritDoc
     */
    protected function _construct()
    {
        $this->_init(
            TranslationStoreModel::class,
            TranslationStoreResource::class
        );
    }
}
