<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Cron;

use GoAi\Translator\Helper\Config as ConfigHelper;
use GoAi\Translator\Model\Config\Source\TranslationType;
use GoAi\Translator\Model\Queue\Publisher\ContentUpdate;

/**
 * Cron job for publishing content updates
 */
class ContentUpdatePublish
{
    /**
     * ContentUpdatePublish constructor.
     *
     * @param ConfigHelper $configHelper
     * @param ContentUpdate $translationPublisher
     */
    public function __construct(
        protected ConfigHelper $configHelper,
        protected ContentUpdate $translationPublisher
    ) {
    }

    /**
     * Execute the cron job
     * @return void
     */
    public function execute(): void
    {
        if ($this->configHelper->isTranslateOnEntityChangeEnabled()) {
            $this->translationPublisher->execute(TranslationType::CONTENT_UPDATE);
        }
    }
}
