<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Controller\Adminhtml\Translation;

use GoAi\Translator\Api\TranslationQueueManagerInterface;
use GoAi\Translator\Model\Config\Source\TranslationStatus;
use GoAi\Translator\Model\ResourceModel\Translation\CollectionFactory;
use Exception;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Ui\Component\MassAction\Filter;


/**
 * Mass Update Status Action
 */
class MassUpdateStatus  extends Action implements HttpPostActionInterface
{
    /**
     * MassUpdateStatus constructor.
     *
     * @param Context $context
     * @param Filter $filter
     * @param CollectionFactory $collectionFactory
     * @param TranslationQueueManagerInterface $translationQueueManager
     */
    public function __construct(
        Context $context,
        protected Filter $filter,
        protected CollectionFactory $collectionFactory,
        protected TranslationQueueManagerInterface $translationQueueManager
    ) {
        parent::__construct($context);
    }

    /**
     * @inheritDoc
     */
    public function execute()
    {
        try {
            $translationIds = $this->filter->getCollection($this->collectionFactory->create())
                ->addFieldToFilter(
                    'status',
                    [
                        'in' => [
                            TranslationStatus::STATUS_SKIPPED,
                            TranslationStatus::STATUS_ERROR_ON_TRANSLATION,
                            TranslationStatus::STATUS_ERROR_ON_SAVING,
                            TranslationStatus::STATUS_ERROR_ON_PROCESSING
                        ]
                    ]
                )
                ->getAllIds();
            $this->translationQueueManager->massUpdateTranslationStatus(
                $translationIds,
                TranslationStatus::STATUS_NEW
            );

            $this->messageManager->addSuccessMessage(
                __('A total of %1 record(s) have been updated.', count($translationIds))
            );
        } catch (Exception $exception) {
            $this->messageManager->addErrorMessage(__('An error occurred: %1', $exception->getMessage()));
        }

        return $this->resultFactory->create(ResultFactory::TYPE_REDIRECT)->setRefererUrl();
    }
}
