<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Controller\Adminhtml\Translation;

use GoAi\Translator\Api\TranslationQueueManagerInterface;
use GoAi\Translator\Controller\Adminhtml\Translation;
use GoAi\Translator\Helper\Config as ConfigHelper;
use GoAi\Translator\Model\Config\Source\TranslationStatus;
use GoAi\Translator\Model\Config\Source\TranslationType;
use Magento\Backend\App\Action\Context;
use Magento\Catalog\Model\ResourceModel\Product\CollectionFactory;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Ui\Component\MassAction\Filter;

/**
 * Mass Add Products to Queue Action
 */
class MassAddProductsToQueue extends AddToQueue implements HttpPostActionInterface
{
    public function __construct(
        Context $context,
        ConfigHelper $configHelper,
        TranslationQueueManagerInterface $translationQueueManager,
        StoreManagerInterface $storeManager,
        private readonly Filter $filter,
        private readonly CollectionFactory $collectionFactory
    ) {
        parent::__construct(
            $context,
            $configHelper,
            $translationQueueManager,
            $storeManager
        );
    }

    /**
     * @inheritDoc 
     */
    protected function getEntityIds(): array
    {
        return $this->filter->getCollection($this->collectionFactory->create())->getAllIds();
    }
}
