<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Api;

use GoAi\Translator\Model\ResourceModel\Translation\Collection as TranslationCollection;

/**
 * Translator Interface
 */
interface TranslatorInterface
{
    /**
     * Get items for translation
     *
     * @param string|null $entityType
     * @return TranslationCollection
     */
    public function getItemsForTranslation(string|null $entityType = null): TranslationCollection;
}
