<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Controller\Adminhtml\Translation;

use GoAi\Translator\Api\TranslationRepositoryInterface;
use GoAi\Translator\Model\ResourceModel\Translation\CollectionFactory;
use Exception;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Ui\Component\MassAction\Filter;


/**
 * Mass Delete Action
 */
class MassDelete  extends Action implements HttpPostActionInterface
{
    /**
     * MassDelete constructor.
     *
     * @param Context $context
     * @param Filter $filter
     * @param CollectionFactory $collectionFactory
     * @param TranslationRepositoryInterface $translationRepository
     */
    public function __construct(
        Context $context,
        protected Filter $filter,
        protected CollectionFactory $collectionFactory,
        protected TranslationRepositoryInterface $translationRepository
    ) {
        parent::__construct($context);
    }

    /**
     * @inheritDoc
     */
    public function execute()
    {
        try {
            $translationIds = $this->filter->getCollection($this->collectionFactory->create())
                ->getAllIds();
            $deleted = 0;


            foreach ($translationIds as $translationId) {
                $this->translationRepository->deleteById((int)$translationId);
                $deleted++;
            }

            $this->messageManager->addSuccessMessage(__('A total of %1 record(s) have been deleted.', $deleted));
        } catch (Exception $exception) {
            $this->messageManager->addErrorMessage(__('An error occurred: %1', $exception->getMessage()));
        }

        return $this->resultFactory->create(ResultFactory::TYPE_REDIRECT)->setRefererUrl();
    }
}
