<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Block\Adminhtml\Product\Attribute\Edit\Button;

use GoAi\Translator\Helper\Config as ConfigHelper;
use Magento\Catalog\Block\Adminhtml\Product\Attribute\Button\Generic;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Registry;
use Magento\Framework\View\Element\UiComponent\Context;

/**
 * Translate Button Block
 */
class Translate extends Generic
{
    /**
     * Translate constructor.
     *
     * @param Context $context
     * @param Registry $registry
     * @param ConfigHelper $configHelper
     * @param RequestInterface $request
     */
    public function __construct(
        Context $context,
        Registry $registry,
        protected ConfigHelper $configHelper,
        protected RequestInterface $request
    ) {
        parent::__construct($context, $registry);
    }

    /**
     * @inheritDoc
     */
    public function getButtonData(): array
    {
        if (!$this->configHelper->isTranslatorEnabled()) {
            return [];
        }

        $attributeId = $this->request->getParam('attribute_id');

        if ($attributeId === null) {
            return [];
        }

        return [
            'label' => __('Translate with AI'),
            'on_click' => 'confirmSetLocation(\'' . __(
                    'Are you sure you want to translate this product?'
                ) . '\', \'' . $this->getUrl('goai_translator/translation/addToQueue') . '\', {data: {selected: ['
                . $attributeId . '], entity_type: "product_eav_attribute"}})',
            'class' => 'action-secondary',
            'sort_order' => 15
        ];
    }
}
