<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Ui\Component\Listing\TranslationLogs;

use GoAi\Translator\Model\ResourceModel\Translation\CollectionFactory as TranslationCollectionFactory;
use Magento\Ui\DataProvider\AbstractDataProvider;

/**
 * Description
 */
class DataProvider extends AbstractDataProvider
{
    /**
     * DataProvider constructor.
     *
     * @param TranslationCollectionFactory $collectionFactory
     * @param string $name
     * @param string $primaryFieldName
     * @param string $requestFieldName
     * @param array $meta
     * @param array $data
     */
    public function __construct(
        protected TranslationCollectionFactory $collectionFactory,
        string $name,
        string $primaryFieldName,
        string $requestFieldName,
        array $meta = [],
        array $data = []
    ) {
        parent::__construct(
            $name,
            $primaryFieldName,
            $requestFieldName,
            $meta,
            $data
        );

        $this->collection = $collectionFactory->create();
    }

    /**
     * @inheritDoc
     */
    public function getData()
    {
        $data = parent::getData();

        if (empty($data['items'])) {
            return $data;
        }

        foreach ($data['items'] as &$item) {
            $item['store_id'] = explode(',', $item['store_ids']);
        }

        return $data;
    }
}
