<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Model\Translator;

use GoAi\Translator\Api\Data\TranslationInterface;
use GoAi\Translator\Model\Config\Source\TranslationType;
use GoAi\Translator\Model\ResourceModel\Translation\Collection as TranslationCollection;

/**
 * Class SiteOnboarding
 */
class SiteOnboarding extends AbstractTranslator
{
    /**
     * @inheritDoc
     */
    protected function addTranslatorTypeFilter(
        TranslationCollection $translationCollection
    ): TranslationCollection {
        return $translationCollection->addFieldToFilter(
            TranslationInterface::TRANSLATION_TYPE,
            ['eq' => TranslationType::SITE_ONBOARDING]
        );
    }
}
