<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Controller\Adminhtml\Translation;

use GoAi\Translator\Api\TranslationQueueManagerInterface;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\Controller\ResultFactory;

/**
 * Onboarding Controller
 */
class Onboarding extends Action implements HttpPostActionInterface
{
    /**
     * Onboarding constructor.
     *
     * @param Context $context
     * @param TranslationQueueManagerInterface $translationQueueManager
     */
    public function __construct(
        Context $context,
        protected TranslationQueueManagerInterface $translationQueueManager
    ) {
        parent::__construct($context);
    }

    /**
     * @inheritDoc
     */
    public function execute()
    {
        $this->translationQueueManager->startOnboarding((int)$this->getRequest()->getParam('store_id'));
        $this->messageManager->addSuccessMessage(__('Onboarding process started successfully.'));

        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        return $resultRedirect->setRefererUrl();
    }
}
