<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Model;

use InvalidArgumentException;
use GoAi\Translator\Api\TranslatorInterface;
use Magento\Framework\ObjectManagerInterface;

/**
 * Factory for creating entity translator instances
 */
class TranslatorFactory
{
    /** @var TranslatorInterface[] $translatorList */
    protected array $translatorList = [];

    /**
     * TranslationFactory constructor.
     *
     * @param ObjectManagerInterface $objectManager
     * @param array $translators
     */
    public function __construct(
        protected ObjectManagerInterface $objectManager,
        protected array $translators = []
    ) {
    }

    /**
     * Create instance by code
     *
     * @param int $code
     * @return TranslatorInterface
     * @throws InvalidArgumentException
     */
    public function create(int $code): TranslatorInterface
    {
        if (isset($this->translatorList[$code])) {
            return $this->translatorList[$code];
        }

        if (!isset($this->translators[$code])) {
            throw new InvalidArgumentException(sprintf('Unknown translator type "%s"', $code));
        }

        return $this->translatorList[$code] = $this->objectManager->create($this->translators[$code]);
    }
}
