<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Model;

use GoAi\Translator\Api\EntityTranslatorInterface;
use InvalidArgumentException;
use Magento\Framework\ObjectManagerInterface;

/**
 * Factory for creating entity translator instances
 */
class EntityTranslatorFactory
{
    /** @var EntityTranslatorInterface[] $entityProcessors */
    protected array $entityProcessors = [];

    /**
     * TranslationFactory constructor.
     *
     * @param ObjectManagerInterface $objectManager
     * @param array $entityTypes
     */
    public function __construct(
        protected ObjectManagerInterface $objectManager,
        protected array $entityTypes = []
    ) {
    }

    /**
     * Create instance by code
     *
     * @param string $code
     * @return EntityTranslatorInterface
     * @throws InvalidArgumentException
     */
    public function create(string $code): EntityTranslatorInterface
    {
        if (isset($this->entityProcessors[$code])) {
            return $this->entityProcessors[$code];
        }

        if (!isset($this->entityTypes[$code])) {
            throw new InvalidArgumentException(sprintf('Unknown entity translator type "%s"', $code));
        }

        return $this->entityProcessors[$code] = $this->objectManager->create($this->entityTypes[$code]);
    }
}
