<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

/**
 * Translation Types
 */
class TranslationType implements OptionSourceInterface
{
    /**
     * Translation Types
     */
    public const CONTENT_UPDATE = 0;
    public const SITE_ONBOARDING = 1;

    /**
     * @inheritDoc
     */
    public function toOptionArray(): array
    {
        return [
            ['label' => __('Content Update'), 'value' => self::CONTENT_UPDATE],
            ['label' => __('Site Onboarding'), 'value' => self::SITE_ONBOARDING]
        ];
    }
}
