<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Cron;

use GoAi\Translator\Helper\Config as ConfigHelper;
use GoAi\Translator\Model\Config\Source\TranslationType;
use GoAi\Translator\Model\Queue\Publisher\SiteOnboarding;

/**
 * Cron job for publishing site onboarding updates
 */
class SiteOnboardingPublish
{
    /**
     * SiteOnboardingPublish constructor.
     *
     * @param ConfigHelper $configHelper
     * @param SiteOnboarding $translationPublisher
     */
    public function __construct(
        protected ConfigHelper $configHelper,
        protected SiteOnboarding $translationPublisher
    ) {
    }

    /**
     * Execute the cron job
     * @return void
     */
    public function execute(): void
    {
        if ($this->configHelper->isTranslatorEnabled()) {
            $this->translationPublisher->execute(TranslationType::SITE_ONBOARDING);
        }
    }
}
