<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

/**
 * Translation Status
 */
class TranslationStatus implements OptionSourceInterface
{
    /**
     * Status List
     */
    public const STATUS_NEW = 0;
    public const STATUS_IN_PROGRESS = 1;
    public const STATUS_TRANSLATED = 2;
    public const STATUS_SKIPPED = 3;
    public const STATUS_ERROR_ON_TRANSLATION = 21;
    public const STATUS_ERROR_ON_SAVING = 22;
    public const STATUS_ERROR_ON_PROCESSING = 23;
    public const STATUS_PENDING = 99;

    /**
     * @inheritDoc
     */
    public function toOptionArray(): array
    {
        return [
            ['label' => __('New'), 'value' => self::STATUS_NEW],
            ['label' => __('In Progress'), 'value' => self::STATUS_IN_PROGRESS],
            ['label' => __('Translated'), 'value' => self::STATUS_TRANSLATED],
            ['label' => __('Error On Translation'), 'value' => self::STATUS_ERROR_ON_TRANSLATION],
            ['label' => __('Error On Saving'), 'value' => self::STATUS_ERROR_ON_SAVING],
            ['label' => __('Error On Processing'), 'value' => self::STATUS_ERROR_ON_PROCESSING],
            ['label' => __('Pending'), 'value' => self::STATUS_PENDING]
        ];
    }
}
