<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Model\EntityTranslator\EavAttribute;

use GoAi\Translator\Model\EntityTranslator\EavAttribute;
use GoAi\Translator\Model\ResourceModel\AttributeLabel as AttributeLabelResource;
use GoAi\Translator\Model\ResourceModel\AttributeOptionValue as AttributeOptionValueResource;
use Magento\Catalog\Model\Product as ProductModel;
use Magento\Catalog\Model\ResourceModel\Product\Attribute\CollectionFactory as AttributeCollectionFactory;
use Magento\Eav\Api\AttributeRepositoryInterface;
use Magento\Eav\Model\AttributeFactory;

/**
 * Class ProductEavAttribute
 */
class ProductEavAttribute extends EavAttribute
{
    /**
     * Entity Type
     */
    public const ENTITY_TYPE = 'product_eav_attribute';

    /**
     * ProductEavAttribute constructor.
     *
     * @param AttributeCollectionFactory $collectionFactory
     * @param AttributeFactory $attributeFactory
     * @param AttributeLabelResource $attributeLabelResource
     * @param AttributeOptionValueResource $optionValueResource
     * @param AttributeRepositoryInterface $attributeRepository
     */
    public function __construct(
        protected AttributeCollectionFactory $collectionFactory,
        AttributeRepositoryInterface $attributeRepository,
        AttributeFactory $attributeFactory,
        AttributeLabelResource $attributeLabelResource,
        AttributeOptionValueResource $optionValueResource
    ) {
        parent::__construct(
            $attributeFactory,
            $attributeRepository,
            $attributeLabelResource,
            $optionValueResource
        );
    }

    /**
     * @param int|null $storeId
     * @inheritDoc
     */
    public function getEntityIdsForTranslation(int|null $storeId = null): array
    {
        return $this->collectionFactory->create()
            ->addFieldToFilter('is_label_translatable', 1)
            ->addFieldToFilter('is_skip_ai_translation', 0)
            ->getAllIds();
    }

    /**
     * @inheritDoc
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function getPreparedEntityData(int $entityId): array
    {
        return $this->getPreparedEntityDataByStoreId($entityId, $this->getDefaultStoreId());
    }

    /**
     * @inheritDoc
     */
    public function getPreparedEntityDataByStoreId(int $entityId, int $storeId, bool $isSkipAttributes = false): array
    {
        return $this->getPreparedEntityDataByAttribute(
            $this->attributeRepository->get(ProductModel::ENTITY, $entityId),
            $storeId
        );
    }
}
