<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Block\Adminhtml\Product\Edit\Button;

use GoAi\Translator\Helper\Config as ConfigHelper;
use Magento\Catalog\Block\Adminhtml\Product\Edit\Button\Generic;
use Magento\Framework\Registry;
use Magento\Framework\View\Element\UiComponent\Context;

/**
 * Translate Button Block
 */
class Translate extends Generic
{

    public function __construct(
        Context $context,
        Registry $registry,
        protected ConfigHelper $configHelper
    ) {
        parent::__construct($context, $registry);
    }

    public function getButtonData(): array
    {
        if (!$this->configHelper->isTranslatorEnabled()) {
            return [];
        }

        $product = $this->getProduct();

        if (!$product || !$product->getId()) {
            return [];
        }

        return [
            'label' => __('Translate with AI'),
            'on_click' => 'confirmSetLocation(\'' . __(
                    'Are you sure you want to translate this product?'
                ) . '\', \'' . $this->getUrl('goai_translator/translation/addToQueue') . '\', {data: {selected: ['
                . $product->getId() . '], entity_type: "product"}})',
            'class' => 'action-secondary',
            'sort_order' => 15
        ];
    }
}
