<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Block\Adminhtml\CmsBlock\Edit\Button;

use GoAi\Translator\Helper\Config as ConfigHelper;
use Magento\Backend\Block\Widget\Context;
use Magento\Cms\Api\BlockRepositoryInterface;
use Magento\Cms\Api\Data\BlockInterface;
use Magento\Cms\Block\Adminhtml\Block\Edit\GenericButton;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;
use Magento\Store\Model\Store;

/**
 * Cms Block Translate Button Block
 */
class Translate extends GenericButton implements ButtonProviderInterface
{

    public function __construct(
        Context $context,
        BlockRepositoryInterface $blockRepository,
        protected ConfigHelper $configHelper
    ) {
        parent::__construct($context, $blockRepository);
    }

    public function getButtonData(): array
    {
        if (!$this->configHelper->isTranslatorEnabled()) {
            return [];
        }

        $blockId = $this->getBlockId();

        if ($blockId === null) {
            return [];
        }

        try {
            $defaultStoreId = $this->configHelper->getDefaultStoreId();
            $block = $this->blockRepository->getById($blockId);

            if ($this->isDisabled($defaultStoreId, $block)) {
                return [];
            }
        } catch (NoSuchEntityException) {
            return [];
        }

        return [
            'label' => __('Translate with AI'),
            'on_click' => 'confirmSetLocation(\'' . __(
                    'Are you sure you want to translate this product?'
                ) . '\', \'' . $this->getUrl('goai_translator/translation/addToQueue') . '\', {data: {selected: ['
                . $blockId . '], entity_type: "cms_block"}})',
            'class' => 'action-secondary',
            'sort_order' => 15
        ];
    }

    /**
     * @param int $defaultStoreId
     * @param BlockInterface $block
     * @return bool
     */
    public function isDisabled(int $defaultStoreId, BlockInterface $block): bool
    {
        return !in_array($defaultStoreId, $block->getStores()) &&
            !in_array(Store::DEFAULT_STORE_ID, $block->getStores());
    }
}
