<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Observer;

use GoAi\Translator\Api\TranslationQueueManagerInterface;
use GoAi\Translator\Helper\Config as ConfigHelper;
use GoAi\Translator\Model\EntityTranslator\CmsPage as CmsPageTranslator;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Store\Model\StoreManagerInterface;

/**
 * This class is responsible for handling the before save product event.
 */
class BeforeSaveCmsPage implements ObserverInterface
{
    /**
     * BeforeSaveProduct constructor.
     *
     * @param ConfigHelper $configHelper
     * @param CmsPageTranslator $cmsPageTranslator
     * @param StoreManagerInterface $storeManager
     * @param TranslationQueueManagerInterface $translationManager
     */
    public function __construct(
        protected ConfigHelper $configHelper,
        protected CmsPageTranslator $cmsPageTranslator,
        protected StoreManagerInterface $storeManager,
        protected TranslationQueueManagerInterface $translationManager
    ) {
    }

    /**
     * Handle the before save product event.
     *
     * @param Observer $observer
     * @return void
     * @throws NoSuchEntityException
     */
    public function execute(Observer $observer): void
    {
        if (!$this->configHelper->isTranslateOnEntityChangeEnabled()) {
            return;
        }

        $storeId = (int)$this->storeManager->getStore()->getId();

        if ($storeId !== $this->cmsPageTranslator->getDefaultStoreId()) {
            return;
        }

        $cmsPage = $observer->getEvent()->getObject();

        if ($this->cmsPageTranslator->isUpdated($cmsPage) && !$cmsPage->getIsSkipAiTranslation()) {
            $this->translationManager->addToTranslationQueue(
                CmsPageTranslator::ENTITY_TYPE,
                (int)$cmsPage->getId(),
                $this->configHelper->getAvailableStoresByType(CmsPageTranslator::ENTITY_TYPE)
            );
        }
    }
}
