<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Model\System;

use Magento\Framework\Data\OptionSourceInterface;

/**
 * Entity Types
 */
class EntityTypes implements OptionSourceInterface
{
    /**
     * EntityTypes constructor.
     *
     * @param array $entityTypes
     */
    public function __construct(
        protected array $entityTypes = []
    ) {
    }

    /**
     * @return array
     */
    public function getEntityTypes(): array
    {
        return $this->entityTypes;
    }

    /**
     * @param string $entityType
     * @return string
     */
    public function getEntityTypeTitle(string $entityType): string
    {
        return $this->entityTypes[$entityType] ?? '';
    }

    /**
     * @inheritDoc
     */
    public function toOptionArray(): array
    {
        $options = [
            [
                'value' => '',
                'label' => __('None'),
            ],
        ];

        foreach ($this->entityTypes as $code => $label) {
            $options[] = [
                'value' => $code,
                'label' => __($label),
            ];
        }

        return $options;
    }
}
