<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Block\Adminhtml\Category\Edit\Button;

use GoAi\Translator\Helper\Config as ConfigHelper;
use Magento\Backend\Block\Template\Context;
use Magento\Catalog\Block\Adminhtml\Category\AbstractCategory;
use Magento\Catalog\Model\CategoryFactory;
use Magento\Catalog\Model\ResourceModel\Category\Tree;
use Magento\Framework\Registry;
use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

/**
 * Category Translate Button Block
 */
class Translate extends AbstractCategory implements ButtonProviderInterface
{
    /**
     * Translate constructor.
     *
     * @param Context $context
     * @param Tree $categoryTree
     * @param Registry $registry
     * @param CategoryFactory $categoryFactory
     * @param ConfigHelper $configHelper
     * @param array $data
     */
    public function __construct(
        Context $context,
        Tree $categoryTree,
        Registry $registry,
        CategoryFactory $categoryFactory,
        protected ConfigHelper $configHelper,
        array $data = []
    ) {
        parent::__construct($context, $categoryTree, $registry, $categoryFactory, $data);
    }

    public function getButtonData(): array
    {
        if (!$this->configHelper->isTranslatorEnabled()) {
            return [];
        }

        $category = $this->getCategory();

        if (!$category || !$category->getId()) {
            return [];
        }

        return [
            'label' => __('Translate with AI'),
            'on_click' => 'confirmSetLocation(\'' . __(
                    'Are you sure you want to translate this product?'
                ) . '\', \'' . $this->getUrl('goai_translator/translation/addToQueue') . '\', {data: {selected: ['
                . $category->getId() . '], entity_type: "category"}})',
            'class' => 'action-secondary',
            'sort_order' => 15
        ];
    }
}
