<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Observer;

use Exception;
use Magento\Catalog\Model\Product;
use Magento\Config\Model\Config\Source\Yesno;
use Magento\Eav\Api\AttributeRepositoryInterface;
use Magento\Eav\Api\Data\AttributeInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

/**
 * Description
 */
class AddFieldToAttributeEditForm implements ObserverInterface
{
    /**
     * AddFieldToAttributeEditForm constructor.
     *
     * @param AttributeRepositoryInterface $attributeRepository
     * @param RequestInterface $request
     * @param Yesno $yesNo
     */
    public function __construct(
        protected AttributeRepositoryInterface $attributeRepository,
        protected RequestInterface $request,
        protected Yesno $yesNo
    ) {
    }

    /**
     * @inheritDoc
     */
    public function execute(Observer $observer): void
    {
        $yesNoSource = $this->yesNo->toOptionArray();

        $form = $observer->getEvent()->getForm();
        $fieldset = $form->getElement('advanced_fieldset');
        $attribute = $this->getAttribute();
        $inputType = $attribute->getFrontendInput();

        if (in_array($inputType, ['text', 'textarea', 'multiline'], true)) {
            $fieldset->addField(
                'is_available_for_translation',
                'select',
                [
                    'name' => 'is_available_for_translation',
                    'label' => __('Enable AI Translation for Values?'),
                    'title' => __('Enable AI Translation for Values?'),
                    'values' => $yesNoSource,
                ]
            );
        }

        $fieldset->addField(
            'is_label_translatable',
            'select',
            [
                'name' => 'is_label_translatable',
                'label' => __('Should the label be translated using AI?'),
                'title' => __('Should the label be translated using AI?'),
                'values' => $yesNoSource,
            ]
        );
    }

    /**
     * Get attribute
     *
     * @return AttributeInterface|null
     */
    protected function getAttribute(): ?AttributeInterface
    {
        try {
            return $this->attributeRepository->get(
                Product::ENTITY,
                (int)$this->request->getParam('attribute_id')
            );
        } catch (Exception $exception) {
            return null;
        }
    }
}
