<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Model;

use GoAi\Translator\Api\Data\TranslationInterface;
use GoAi\Translator\Model\ResourceModel\Translation as TranslationResourceModel;
use Magento\Framework\Model\AbstractModel;

/**
 * Translation Model
 */
class Translation extends AbstractModel implements TranslationInterface
{
    /**
     * Prefix of model events names
     *
     * @var string
     */
    protected $_eventPrefix = 'goai_translation';

    /**
     * @inheritdoc
     */
    protected function _construct()
    {
        $this->_init(TranslationResourceModel::class);
    }

    /**
     * @inheritDoc
     */
    public function getEntityId()
    {
        return $this->getTranslationId();
    }

    /**
     * @inheritDoc
     */
    public function setEntityId($entityId)
    {
        return $this->setTranslationId($entityId);
    }

    public function getTranslationId(): int
    {
        return (int)$this->getData(TranslationInterface::TRANSLATION_ID);
    }

    public function setTranslationId(int $translationId): TranslationInterface
    {
        return $this->setData(TranslationInterface::TRANSLATION_ID, $translationId);
    }

    /**
     * @inheritDoc
     */
    public function getEntityType(): string
    {
        return (string)$this->getData(TranslationInterface::ENTITY_TYPE);
    }

    /**
     * @inheritDoc
     */
    public function setEntityType(string $entityType): TranslationInterface
    {
        return $this->setData(TranslationInterface::ENTITY_TYPE, $entityType);
    }

    /**
     * @inheritDoc
     */
    public function getOriginalEntityId(): int
    {
        return (int)$this->getData(TranslationInterface::ORIGINAL_ENTITY_ID);
    }

    /**
     * @inheritDoc
     */
    public function setOriginalEntityId(int $entityId): TranslationInterface
    {
        return $this->setData(TranslationInterface::ORIGINAL_ENTITY_ID, $entityId);
    }

    /**
     * @inheritDoc
     */
    public function getTranslationType(): int
    {
        return (int)$this->getData(TranslationInterface::TRANSLATION_TYPE);
    }

    /**
     * @inheritDoc
     */
    public function setTranslationType(int $translationType): TranslationInterface
    {
        return $this->setData(TranslationInterface::TRANSLATION_TYPE, $translationType);
    }

    /**
     * @inheritDoc
     */
    public function getStatus(): int
    {
        return (int)$this->getData(TranslationInterface::STATUS);
    }

    /**
     * @inheritDoc
     */
    public function setStatus(int $status): TranslationInterface
    {
        return $this->setData(TranslationInterface::STATUS, $status);
    }

    /**
     * @inheritDoc
     */
    public function getCreatedAt(): string
    {
        return (string)$this->getData(TranslationInterface::CREATED_AT);
    }

    /**
     * @inheritDoc
     */
    public function setCreatedAt(string $createdAt): TranslationInterface
    {
        return $this->setData(TranslationInterface::CREATED_AT, $createdAt);
    }

    /**
     * @inheritDoc
     */
    public function getUpdatedAt(): string
    {
        return (string)$this->getData(TranslationInterface::UPDATED_AT);
    }

    /**
     * @inheritDoc
     */
    public function setUpdatedAt(string $updatedAt): TranslationInterface
    {
        return $this->setData(TranslationInterface::UPDATED_AT, $updatedAt);
    }

    /**
     * @inheritDoc
     */
    public function getComment(): string
    {
        return (string)$this->getData(TranslationInterface::COMMENT);
    }

    /**
     * @inheritDoc
     */
    public function setComment(string $comment): TranslationInterface
    {
        return $this->setData(TranslationInterface::COMMENT, $comment);
    }

    /**
     * @inheritDoc
     */
    public function getStoreIds(): array
    {
        $storeIds = $this->getData(TranslationInterface::STORE_IDS);

        if (is_string($storeIds)) {
            return explode(',', $storeIds);
        }

        if (is_array($storeIds)) {
            return $storeIds;
        }

        return [];
    }

    /**
     * @inheritDoc
     */
    public function setStoreIds(array $storeIds): TranslationInterface
    {
        if (is_array($storeIds)) {
            $storeIds = implode(',', $storeIds);
        }

        return $this->setData(TranslationInterface::STORE_IDS, $storeIds);
    }
}
