<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\Translator\Model\ResourceModel\Translation;

use GoAi\Translator\Api\Data\TranslationInterface;
use GoAi\Translator\Api\Data\TranslationStoreInterface;
use GoAi\Translator\Model\Translation as TranslationModel;
use GoAi\Translator\Model\ResourceModel\Translation as TranslationResource;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;
use Zend_Db_Expr;

/**
 * Class Collection
 */
class Collection extends AbstractCollection
{
    /**
     * @var string
     */
    protected $_idFieldName = TranslationInterface::TRANSLATION_ID;

    /**
     * @inheritDoc
     */
    protected function _construct()
    {
        $this->_init(
            TranslationModel::class,
            TranslationResource::class
        );
    }

    /**
     * Add store data to each item
     *
     * @return $this
     */
    protected function _afterLoad()
    {
        $translationIds = $this->getColumnValues(TranslationInterface::TRANSLATION_ID);

        if (!empty($translationIds)) {
            $stores = $this->getConnection()->fetchPairs(
                $this->getConnection()->select()
                    ->from(
                        TranslationStoreInterface::TABLE_NAME,
                        [TranslationStoreInterface::TRANSLATION_ID, new Zend_Db_Expr('GROUP_CONCAT(store_id)')]
                    )
                    ->where('translation_id IN (?)', $translationIds)
                    ->group(TranslationStoreInterface::TRANSLATION_ID)
            );

            foreach ($this as $item) {
                $item->setData(TranslationInterface::STORE_IDS, $stores[$item->getId()] ?? '');
            }
        }

        return parent::_afterLoad();
    }

    public function addStoreFilter($storeId): self
    {
        if ($storeId) {
            $this->getSelect()->join(
                ['translation_store' => TranslationStoreInterface::TABLE_NAME],
                'main_table.translation_id = translation_store.translation_id',
                []
            )->where('translation_store.store_id = ?', $storeId);
        }

        return $this;
    }

    /**
     * @return $this
     */
    public function addWithoutStoreFilter(): self
    {
        $this->getSelect()->joinLeft(
            ['translation_store' => TranslationStoreInterface::TABLE_NAME],
            'main_table.translation_id = translation_store.translation_id',
            []
        )->where('translation_store.store_id IS NULL');

        return $this;
    }
}
