<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\TranslatorMagefanBlog\Block\Adminhtml\Tag\Edit\Button;

use GoAi\Translator\Helper\Config as ConfigHelper;
use GoAi\TranslatorMagefanBlog\Block\Adminhtml\GenericButton;
use GoAi\TranslatorMagefanBlog\Model\EntityTranslator\Tag;
use Magefan\Blog\Model\Tag as TagModel;
use Magefan\Blog\Model\TagRepository;
use Magento\Backend\Block\Widget\Context;
use Magento\Framework\AuthorizationInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;
use Magento\Store\Model\Store;

/**
 * Category Translate Button Block
 */
class Translate extends GenericButton implements ButtonProviderInterface
{
    public function __construct(
        Context $context,
        ConfigHelper $configHelper,
        protected TagRepository $tagRepository,
        AuthorizationInterface $authorization = null
    ) {
        parent::__construct($context, $configHelper, $authorization);
    }


    /**
     * @inheritDoc
     */
    protected function isEnabled(int $objectId): bool
    {
        try {
            return !$this->isDisabled($this->tagRepository->getById($objectId));
        } catch (NoSuchEntityException) {
            return false;
        }
    }

    /**
     * @param TagModel $tag
     * @return bool
     */
    public function isDisabled(TagModel $tag): bool
    {
        return !in_array($this->configHelper->getDefaultStoreId(), $tag->getStoreIds()) &&
            !in_array(Store::DEFAULT_STORE_ID, $tag->getStoreIds());
    }

    /**
     * @inheritDoc
     */
    protected function getEntityType(): string
    {
        return Tag::ENTITY_TYPE;
    }
}
