<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\TranslatorMagefanBlog\Block\Adminhtml;

use GoAi\Translator\Helper\Config as ConfigHelper;
use Magento\Backend\Block\Widget\Context;
use Magento\Framework\AuthorizationInterface;
use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;
use Magefan\Community\Block\Adminhtml\Edit\GenericButton as BaseGenericButton;

/**
 * Block Translate Generic Button
 */
abstract class GenericButton extends BaseGenericButton implements ButtonProviderInterface
{
    /**
     * GenericButton constructor.
     *
     * @param Context $context
     * @param ConfigHelper $configHelper
     * @param AuthorizationInterface|null $authorization
     */
    public function __construct(
        Context $context,
        protected ConfigHelper $configHelper,
        AuthorizationInterface $authorization = null
    ) {
        parent::__construct($context, $authorization);
    }

    /**
     * @inheritDoc
     */
    public function getButtonData(): array
    {
        if (!$this->configHelper->isTranslatorEnabled()) {
            return [];
        }

        $objectId = $this->getObjectId();

        if ($objectId === null) {
            return [];
        }

        if (!$this->isEnabled((int)$objectId)) {
            return [];
        }

        return [
            'label' => __('Translate with AI'),
            'on_click' => 'confirmSetLocation(\'' . __(
                    'Are you sure you want to translate this product?'
                ) . '\', \'' . $this->getUrl('goai_translator/translation/addToQueue') . '\', {data: {selected: ['
                . $objectId . '], entity_type: "' . $this->getEntityType() . '"}})',
            'class' => '',
            'sort_order' => 15
        ];
    }

    /**
     * @param int $objectId
     * @return bool
     */
    abstract protected function isEnabled(int $objectId): bool;

    /**
     * Get button data for translation
     * @return string
     */
    abstract protected function getEntityType(): string;
}
