<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\TranslatorMagefanBlog\Block\Adminhtml\Post\Edit\Button;

use GoAi\Translator\Helper\Config as ConfigHelper;
use GoAi\TranslatorMagefanBlog\Block\Adminhtml\GenericButton;
use GoAi\TranslatorMagefanBlog\Model\EntityTranslator\Post;
use Magefan\Blog\Model\Post as PostModel;
use Magefan\Blog\Model\PostRepository;
use Magento\Backend\Block\Widget\Context;
use Magento\Framework\AuthorizationInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;
use Magento\Store\Model\Store;

/**
 * Category Translate Button Block
 */
class Translate extends GenericButton implements ButtonProviderInterface
{
    public function __construct(
        Context $context,
        ConfigHelper $configHelper,
        protected PostRepository $postRepository,
        AuthorizationInterface $authorization = null
    ) {
        parent::__construct($context, $configHelper, $authorization);
    }


    /**
     * @inheritDoc
     */
    protected function isEnabled(int $objectId): bool
    {
        try {
            return !$this->isDisabled($this->postRepository->getById($objectId));
        } catch (NoSuchEntityException) {
            return false;
        }
    }

    /**
     * @param PostModel $post
     * @return bool
     */
    public function isDisabled(PostModel $post): bool
    {
        return !in_array($this->configHelper->getDefaultStoreId(), $post->getStoreIds()) &&
            !in_array(Store::DEFAULT_STORE_ID, $post->getStoreIds());
    }

    /**
     * @inheritDoc
     */
    protected function getEntityType(): string
    {
        return Post::ENTITY_TYPE;
    }
}
