<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\TranslatorMagefanBlog\Observer;

use GoAi\Translator\Api\TranslationQueueManagerInterface;
use GoAi\Translator\Helper\Config as ConfigHelper;
use GoAi\TranslatorMagefanBlog\Model\EntityTranslator\Tag as TagTranslator;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Store\Model\StoreManagerInterface;

/**
 * This class is responsible for handling the before tag save event in the Magefan Blog module.
 */
class BeforeSaveTag implements ObserverInterface
{
    /**
     * BeforeSaveProduct constructor.
     *
     * @param ConfigHelper $configHelper
     * @param TagTranslator $tagTranslator
     * @param StoreManagerInterface $storeManager
     * @param TranslationQueueManagerInterface $translationManager
     */
    public function __construct(
        protected ConfigHelper $configHelper,
        protected TagTranslator $tagTranslator,
        protected StoreManagerInterface $storeManager,
        protected TranslationQueueManagerInterface $translationManager
    ) {
    }

    /**
     * Handle the before save product event.
     *
     * @param Observer $observer
     * @return void
     * @throws NoSuchEntityException
     */
    public function execute(Observer $observer): void
    {
        if (!$this->configHelper->isTranslateOnEntityChangeEnabled()) {
            return;
        }

        $storeId = (int)$this->storeManager->getStore()->getId();

        if ($storeId !== $this->tagTranslator->getDefaultStoreId()) {
            return;
        }

        $tag = $observer->getEvent()->getBlogTag();

        if ($this->tagTranslator->isUpdated($tag) && !$tag->getIsSkipAiTranslation()) {
            $this->translationManager->addToTranslationQueue(
                TagTranslator::ENTITY_TYPE,
                (int)$tag->getId(),
                $this->configHelper->getAvailableStoresByType(TagTranslator::ENTITY_TYPE)
            );
        }
    }
}
