<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\TranslatorMagefanBlog\Block\Adminhtml\Category\Edit\Button;

use GoAi\Translator\Helper\Config as ConfigHelper;
use GoAi\TranslatorMagefanBlog\Block\Adminhtml\GenericButton;
use GoAi\TranslatorMagefanBlog\Model\EntityTranslator\Category;
use Magefan\Blog\Model\Category as CategoryModel;
use Magefan\Blog\Model\CategoryRepository;
use Magento\Backend\Block\Widget\Context;
use Magento\Framework\AuthorizationInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;
use Magento\Store\Model\Store;

/**
 * Category Translate Button Block
 */
class Translate extends GenericButton implements ButtonProviderInterface
{
    public function __construct(
        Context $context,
        ConfigHelper $configHelper,
        protected CategoryRepository $categoryRepository,
        AuthorizationInterface $authorization = null
    ) {
        parent::__construct($context, $configHelper, $authorization);
    }


    /**
     * @inheritDoc
     */
    protected function isEnabled(int $objectId): bool
    {
        try {
            return !$this->isDisabled($this->categoryRepository->getById($objectId));
        } catch (NoSuchEntityException) {
            return false;
        }
    }

    /**
     * @param CategoryModel $category
     * @return bool
     */
    public function isDisabled(CategoryModel $category): bool
    {
        return !in_array($this->configHelper->getDefaultStoreId(), $category->getStoreIds()) &&
            !in_array(Store::DEFAULT_STORE_ID, $category->getStoreIds());
    }

    /**
     * @inheritDoc
     */
    protected function getEntityType(): string
    {
        return Category::ENTITY_TYPE;
    }
}
