<?php
/**
 * @copyright 2025 GoMage
 * All rights reserved
 */
declare(strict_types=1);

namespace GoAi\TranslatorAmastyFaq\Observer;

use GoAi\Translator\Api\TranslationQueueManagerInterface;
use GoAi\Translator\Helper\Config as ConfigHelper;
use GoAi\TranslatorAmastyFaq\Model\EntityTranslator\Category as CategoryTranslator;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Store\Model\StoreManagerInterface;

/**
 * This class is responsible for handling the before category save event in the Amasty Faq module.
 */
class BeforeSaveCategory implements ObserverInterface
{
    /**
     * BeforeSaveProduct constructor.
     *
     * @param ConfigHelper $configHelper
     * @param CategoryTranslator $categoryTranslator
     * @param StoreManagerInterface $storeManager
     * @param TranslationQueueManagerInterface $translationManager
     */
    public function __construct(
        protected ConfigHelper $configHelper,
        protected CategoryTranslator $categoryTranslator,
        protected StoreManagerInterface $storeManager,
        protected TranslationQueueManagerInterface $translationManager
    ) {
    }

    /**
     * Handle the before save product event.
     *
     * @param Observer $observer
     * @return void
     * @throws NoSuchEntityException
     */
    public function execute(Observer $observer): void
    {
        if (!$this->configHelper->isTranslateOnEntityChangeEnabled()) {
            return;
        }

        $storeId = (int)$this->storeManager->getStore()->getId();

        if ($storeId !== $this->categoryTranslator->getDefaultStoreId()) {
            return;
        }

        $category = $observer->getEvent()->getFaqCategory();

        if ($this->categoryTranslator->isUpdated($category) && !$category->getIsSkipAiTranslation()) {
            $this->translationManager->addToTranslationQueue(
                CategoryTranslator::ENTITY_TYPE,
                (int)$category->getId(),
                $this->configHelper->getAvailableStoresByType(CategoryTranslator::ENTITY_TYPE)
            );
        }
    }
}
